<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" href="<?php echo e(asset('images/favicon.ico')); ?>" type="image/x-icon">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <title>Atendimento</title>
</head>
<div class="container">
    <div class="card mt-3 mb-4 border-light shadow">
        <div class="card-header d-flex justify-content-between">
            <span>Pesquisar</span>
        </div>

        <div class="card-body">
            <form action="<?php echo e(route('conta.index')); ?>">
                <div class="row">

                    <div class="col-md-3 col-sm-12">
                        <label class="form-label" for="analista">Analista</label>
                        <input type="text" name="analista" id="analista" class="form-control"
                            placeholder="Nome do Analista" value="<?php echo e($analista); ?>" />
                    </div>

                    <div class="col-md-3 col-sm-12">
                        <label class="form-label" for="data_inicio">Data Início</label>
                        <input type="date" name="data_inicio" id="data_inicio" class="form-control" value="<?php echo e($data_inicio); ?>" />
                    </div>

                    <div class="col-md-3 col-sm-12">
                        <label class="form-label" for="data_fim">Data Fim</label>
                        <input type="date" name="data_fim" id="data_fim" class="form-control" value="<?php echo e($data_fim); ?>"/>
                    </div>

                    <div class="col-md-3 col-sm-12 mt-3 pt-4">
                        <button type="submit" class="btn btn-info btn-sm">Pesquisar</button>
                        <a href="<?php echo e(route('conta.index')); ?>" class="btn btn-warning btn-sm">Limpar</a>
                    </div>

                </div>

            </form>

        </div>
        <div class="container">
            <div style="margin: 0%">
                <h1 style="text-align: center"">Visitas</h1>
            </div>
            <div class="container">
                <a href="<?php echo e(route('welcome')); ?>">
                    <button class="btn btn-primary" type="button">Voltar</button>
                </a>
                <a class="btn btn-success" href="<?php echo e(route('conta.create')); ?>">Cadastrar Visitas</a>
                <a href="<?php echo e(url('gerar-pdf-conta?' . request()->getQueryString())); ?>" class="btn btn-warning">Gerar PDF</a>
            </div>
            <br>
                 <?php if(session('sucesso')): ?>
                 <div class="alert alert-danger m-3" role="alert">
                    <?php echo e(session('sucesso')); ?>

                 </div>
            <?php endif; ?>
            <br>
            <br>
            <?php $__empty_1 = true; $__currentLoopData = $contas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <table class="table table-striped"">
                    <tr>
                        <th>ID</th>
                        <th>Data</th>
                        <th>Empresa</th>
                        <th>Analista</th>
                        <th>Valor</th>
                        <th>Motivo</th>
                        <th>Veiculo</th>

                    </tr>

                    <tr>
                        <td><?php echo e($conta->id); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($conta->data)->tz('America/Sao_Paulo')->format('d/m/Y')); ?></td>
                        <td><?php echo e($conta->cliente); ?></td>
                        <td> <?php echo e($conta->analista); ?></td>
                        <td> <?php echo e('R$ ' . number_format($conta->valor, 2, ',', '.')); ?></td>
                        <td> <?php echo e($conta->motivo); ?></td>
                        <td> <?php echo e($conta->veiculo); ?></td>



                        <td><a href="<?php echo e(route('conta.show', ['conta' => $conta->id])); ?>">
                                <button type="button" class="btn btn-secondary">Visualizar</button>
                            </a></td>

                        <td> <a href="<?php echo e(route('conta.edit', ['conta' => $conta->id])); ?>">
                                <button class="btn btn-warning" type="button">Editar</button>
                            </a> </td>


                        <form id="formExcluir<?php echo e($conta->id); ?>" action="<?php echo e(route('conta.destroy', ['conta' => $conta->id])); ?>" method='POST'>
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('delete'); ?>

                            <td><button type="submit" onclick="confirmarExclusao(event,<?php echo e($conta->id); ?>)('Tem certeza que deseja apagar?')"
                                    class="btn btn-danger">Apagar</button></td>
                        </form>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <span style="color:red">Nenhuma visita encontrada!</span>
            <?php endif; ?>
            </tr>
            </table>
            <?php echo e($contas->onEachSide(0)->links()); ?>


        </div>

        </body>
    </div>
</div>
</html>
<?php /**PATH C:\Projeto_atendimento\Atend\resources\views/contas/index.blade.php ENDPATH**/ ?>