<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" href="<?php echo e(asset('images/favicon.ico')); ?>" type="image/x-icon">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


</head>
<title>Atendimento</title>




<div class="container">
    <h1 style="text-align: center">Visualização de Visitas</h1>



    <a href="<?php echo e(route('conta.index')); ?>">
        <button class="btn btn-primary">Voltar</button>
    </a>

    <a class="btn btn-success" href="<?php echo e(route('conta.create')); ?>">Cadastrar contas</a>

    <a href="<?php echo e(route('conta.edit', ['conta' => $conta->id])); ?>">
        <button class="btn btn-warning" type="button">Editar</button>
    </a>
    <br>
    <br>

    <?php if(session('sucesso')): ?>
        <div class="alert alert-success m-3" role="alert">
            <?php echo e(session('sucesso')); ?>

        </div>
    <?php endif; ?>

    <br>
    <br>
    <table class="table table-striped table-hover">
        <tr>
            <th>ID</th>
            <th>Data</th>
            <th>Empresa</th>
            <th>Analista</th>
            <th>Valor</th>
            <th>Motivo</th>
            <th>Veiculo</th>

        </tr>

        <tr>
            <td><?php echo e($conta->id); ?></td>
            <td><?php echo e(\Carbon\Carbon::parse($conta->data)->tz('America/Sao_Paulo')->format('d/m/Y')); ?></td>
            <td><?php echo e($conta->cliente); ?></td>
            <td> <?php echo e($conta->analista); ?></td>
            <td> <?php echo e('R$ ' . number_format($conta->valor, 2, ',', '.')); ?></td>
            <td> <?php echo e($conta->motivo); ?></td>
            <td> <?php echo e($conta->veiculo); ?></td>
        </tr>
    </table>

</div>

</body>

</html>
<?php /**PATH C:\atendimento\Atend\resources\views/contas/show.blade.php ENDPATH**/ ?>