<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" href="{{ asset('images/favicon.ico') }}" type="image/x-icon">

    @vite(['resources/sass/app.scss', 'resources/js/app.js'])

    <div class="container">

        <h1 style="text-align: center">Edição</h1>

        <div class="btn-group" role="group">
            <a class="btn btn-primary" href="{{ route('conta.index') }}">Lista de Visitas</a>
            <a class="btn btn-info" href="{{ route('home') }}">Home</a>
        </div>
        <br>
        <br>
        <span style="color:rgb(2, 1, 17)">
            @if (session('error'))
                {{ session('error') }}
        </span>
        @endif





        @if ($errors->any())
            <span style="color:red">

                @foreach ($errors->all() as $error)
                    {{ $error }}
                @endforeach

            </span>

        @endif

        <form action="{{ route('conta.update', ['conta' => $conta->id]) }}" method="POST">
            {{-- INDICA QUE A REQUISIÇÃO VEM DE UMA PAGINA INTERNA --}}
            @csrf
            @method('PUT')

            <div class="mb-3">
                <label class="form-label">Empresa</label>
                <input type="text" class="form-control" name="cliente" id="cliente" placeholder="Empresa"
                    value="{{ old('cliente', $conta->cliente) }}">
            </div>
            <div class="mb-3">
                <label class="form-label">Data</label>
                <input type="date" class="form-control" name="data" id="data"
                    value="{{ old('data', $conta->data) }}">
            </div>
            <div class="mb-3">
                <label class="form-label">Analista</label>
                <input type="text" name="analista" class="form-control" id="analista" placeholder="Analista"
                    value="{{ old('analista', $conta->analista) }}">
                <label class="form-label">Veiculo</label>
                <input type="text" name="veiculo" class="form-control" id="veiculo" placeholder="Veiculo"
                    value="{{ $conta->veiculo }}">
                <label class="form-label">Motivo</label>
                <input type="text" name="motivo" class="form-control" id="motivo" placeholder="Motivo"
                    value="{{ $conta->motivo }}">
                <label class="form-label">Valor</label>
                <input type="text" name="valor" class="form-control" id="valor" placeholder="valor"
                    value="{{ old('valor', $conta->valor) }}">
                <br>
                <button type="submit" class="btn btn-success btn-lg">Editar</button>

        </form>
    </div>

    </body>

</html>
