<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" href="{{ asset('images/favicon.ico') }}" type="image/x-icon">

    @vite(['resources/sass/app.scss', 'resources/js/app.js'])

    <title>Cadastro</title>
</head>

<div class="container">


    <h2 style="text-align: center ">Cadastro de Visitas</h2>

    <div class="btn-group" role="group" >
        <a class="btn btn-primary" href="{{ route('conta.index') }}">Lista de Visitas</a>
         <a class="btn btn-info" href="{{ route('home') }}">Home</a>
    </div>
    <br>
    <br>
    @if ($errors->any())
        <span style="color:red">

            @foreach ($errors->all() as $error)
                {{ $error }}
            @endforeach

        </span>

    @endif

    <form action="{{ route('conta.store') }}" method="POST">
        {{-- INDICA QUE A REQUISIÇÃO VEM DE UMA PAGINA INTERNA --}}
        @csrf
        <div class="mb-3">
            <label class="form-label">Empresa</label>
            <input type="text" name="cliente" class="form-control" id="cliente" placeholder="Empresa"
                value="{{ old('cliente') }}">
        </div>
        <div class="mb-3">
            <label class="form-label">Data</label>
            <input type="date" class="form-control"name="data" id="data">
        </div>
        <div class="mb-3">
            <label class="form-label">Analista</label>
            <input type="text" name="analista" class="form-control" id="analista" placeholder="Analista"
                value="{{ old('analista') }}">
        </div>
        <div class="mb-3">
            <label class="form-label">Veiculo</label>
            <input type="text" name="veiculo" class="form-control" id="veiculo" placeholder="Veiculo">
        </div>
        <div class="mb-3">
            <label class="form-label">Motivo</label>
            <input type="text" name="motivo" class="form-control" id="motivo" placeholder="Motivo">
        </div>
        <div class="mb-3">
            <label class="form-label">Valor</label>
            <input type="text" name="valor" class="form-control" id="valor"
                placeholder="Valor quebrado usar R$ 20.40 valor inteiro  20  " value="{{ old('valor') }}">
        </div>
        <button type="submit" class="btn btn-success ">Cadastrar</button>

    </form>

</div>
</body>

</html>
