<?php

namespace App\Http\Controllers;
use App\Models\Conta;
use Illuminate\Http\Request;
use PDF;
// use Barryvdh\DomPDF\Facade\pdf;
use App\Http\Requests\ContaRequest;
use Exception;

class ContaController extends Controller
{
   public function welcome(){

    return view('welcome');

   }
    // Listar as contas
    public function index(Request $request)
    {
        $contas = Conta::when($request->has('analista'), function ($whenQuery) use ($request){
            $whenQuery->where('analista', 'like', '%' . $request->analista . '%');
        })
        ->when($request->filled('data_inicio'), function ($whenQuery) use ($request){
            $whenQuery->where('data', '>=', \Carbon\Carbon::parse($request->data_inicio)->format('Y-m-d'));
        })
        ->when($request->filled('data_fim'), function ($whenQuery) use ($request){
            $whenQuery->where('data', '<=', \Carbon\Carbon::parse($request->data_fim)->format('Y-m-d'));
        })
        ->orderByDesc('created_at')
        ->paginate('4')
        ->withQueryString();



        // Carregar a VIEW
        return view('contas.index',[
            'contas'=> $contas,
            'analista' => $request->analista,
            'data_inicio' => $request->data_inicio,
            'data_fim' => $request->data_fim,
        ]);

    }

    // Detalhes da conta
    public function show(Conta $conta)
    {

        // Carregar a VIEW
        return view('contas.show',['conta'=>$conta]);
    }

    // Carregar o formulário cadastrar nova conta
    public function create()
    {
        // Carregar a VIEW
        return view('contas.create');
    }

    // Cadastrar no banco de dados nova conta
    public function store(ContaRequest $request)
    {

       //validar o formulario
       $request -> validated();



        // Cadastrar no banco de dados na tabela contas os valores de todos os campos
        $conta = Conta::create($request->all());
        return redirect()->route('conta.show',['conta' => $conta->id])->with('sucesso','Visita cadastrada com sucesso');



    }

    // Carregar o formulário editar a conta
    public function edit(Conta $conta)
    {
        // Carregar a VIEW
        return view('contas.edit',['conta' => $conta]);
    }

    // Editar no banco de dados a conta
    public function update(ContaRequest $request, Conta $conta)
    {

              //validar o formulario
       $request -> validated();

       try {

       //Editar as informações no Banco de dados
       $conta->update([
        'cliente'=> $request->cliente,
        'data'=> $request->data,
        'analista'=> $request->analista,
        'veiculo'=> $request->veiculo,
        'motivo'=> $request->motivo,
        'valor'=> $request->valor,

       ]);
            // Redirecionar o usuário, enviar a mensagem de sucesso
            return redirect()->route('conta.show',['conta' => $conta->id])->with('sucesso','Visita editada com sucesso');
      } catch (Exception $e){
          // Redirecionar o usuário, enviar a mensagem de erro
           return back()->withInput()->with('error', 'Visita não editada');
      }
    }

    // Excluir a conta do banco de dados
    public function destroy(Conta $conta)
    {

        // Excluir o registro do banco de dados
        $conta->delete();


        // Redirecionar o usuário, enviar a mensagem de sucesso
        return redirect()->route('conta.index')->with('sucesso','Visita apagada com sucesso');
    }

     // Gerar PDF
     public function gerarPdf(Request $request){

        // Recuperar os registros do banco dados
        //$contas = Conta::orderByDesc('created_at')->get();

        // Recuperar e pesquisar os registros do banco dados
        $contas = Conta::when($request->has('analista'), function ($whenQuery) use ($request){
            $whenQuery->where('analista', 'like', '%' . $request->analista . '%');
        })
        ->when($request->filled('data_inicio'), function ($whenQuery) use ($request){
            $whenQuery->where('data', '>=', \Carbon\Carbon::parse($request->data_inicio)->format('Y-m-d'));
        })
        ->when($request->filled('data_fim'), function ($whenQuery) use ($request){
            $whenQuery->where('data', '<=', \Carbon\Carbon::parse($request->data_fim)->format('Y-m-d'));
        })
        ->orderByDesc('created_at')
        ->get();

        // Calcular a soma total dos valores
        $totalValor = $contas->sum('valor');

        // Carregar a string com o HTML/conteúdo e determinar a orientação e o tamanho do arquivo
        $pdf = PDF::loadView('contas.gerar-pdf', [
            'contas' => $contas,
            'totalValor' => $totalValor
            ])->setPaper('a4', 'portrait');

        // Fazer o download do arquivo
        return $pdf->download('Visita.pdf');

    }
}
