<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" href="<?php echo e(asset('images/favicon.ico')); ?>" type="image/x-icon">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>

    <div class="container">

        <h1 style="text-align: center">Edição</h1>

        <div class="btn-group" role="group">
            <a class="btn btn-primary" href="<?php echo e(route('conta.index')); ?>">Lista de Visitas</a>
            <a class="btn btn-info" href="<?php echo e(route('welcome')); ?>">Home</a>
        </div>
        <br>
        <br>
        <span style="color:rgb(2, 1, 17)">
            <?php if(session('error')): ?>
                <?php echo e(session('error')); ?>

        </span>
        <?php endif; ?>





        <?php if($errors->any()): ?>
            <span style="color:red">

                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </span>

        <?php endif; ?>

        <form action="<?php echo e(route('conta.update', ['conta' => $conta->id])); ?>" method="POST">
            
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-3">
                <label class="form-label">Empresa</label>
                <input type="text" class="form-control" name="cliente" id="cliente" placeholder="Empresa"
                    value="<?php echo e(old('cliente', $conta->cliente)); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">Data</label>
                <input type="date" class="form-control" name="data" id="data"
                    value="<?php echo e(old('data', $conta->data)); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">Analista</label>
                <input type="text" name="analista" class="form-control" id="analista" placeholder="Analista"
                    value="<?php echo e(old('analista', $conta->analista)); ?>">
                <label class="form-label">Veiculo</label>
                <input type="text" name="veiculo" class="form-control" id="veiculo" placeholder="Veiculo"
                    value="<?php echo e($conta->veiculo); ?>">
                <label class="form-label">Motivo</label>
                <input type="text" name="motivo" class="form-control" id="motivo" placeholder="Motivo"
                    value="<?php echo e($conta->motivo); ?>">
                <label class="form-label">Valor</label>
                <input type="text" name="valor" class="form-control" id="valor" placeholder="valor"
                    value="<?php echo e(old('valor', $conta->valor)); ?>">
                <br>
                <button type="submit" class="btn btn-success btn-lg">Editar</button>

        </form>
    </div>

    </body>

</html>
<?php /**PATH C:\Projeto_atendimento\Atend\resources\views/contas/edit.blade.php ENDPATH**/ ?>