<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" href="{{ asset('images/favicon.ico') }}" type="image/x-icon">

    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


</head>
<title>Atendimento</title>




<div class="container">
    <h1 style="text-align: center">Visualização de Visitas</h1>



    <a href="{{ route('conta.index') }}">
        <button class="btn btn-primary">Voltar</button>
    </a>

    <a class="btn btn-success" href="{{ route('conta.create') }}">Cadastrar contas</a>

    <a href="{{ route('conta.edit', ['conta' => $conta->id]) }}">
        <button class="btn btn-warning" type="button">Editar</button>
    </a>
    <br>
    <br>

    @if (session('sucesso'))
        <div class="alert alert-success m-3" role="alert">
            {{ session('sucesso') }}
        </div>
    @endif

    <br>
    <br>
    <table class="table table-striped table-hover">
        <tr>
            <th>ID</th>
            <th>Data</th>
            <th>Empresa</th>
            <th>Analista</th>
            <th>Valor</th>
            <th>Motivo</th>
            <th>Veiculo</th>

        </tr>

        <tr>
            <td>{{ $conta->id }}</td>
            <td>{{ \Carbon\Carbon::parse($conta->data)->tz('America/Sao_Paulo')->format('d/m/Y') }}</td>
            <td>{{ $conta->cliente }}</td>
            <td> {{ $conta->analista }}</td>
            <td> {{ 'R$ ' . number_format($conta->valor, 2, ',', '.') }}</td>
            <td> {{ $conta->motivo }}</td>
            <td> {{ $conta->veiculo }}</td>
        </tr>
    </table>

</div>

</body>

</html>
