<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <title>Contas</title>
</head>

<body style="font-size: 12px;">
    <h2 style="text-align: center">Visitas</h2>

    <table style="border-collapse: collapse; width: 100%;">
        <thead>
            <tr style="background-color: #adb5bd;">
                <th style="border: 1px solid #ccc;">ID</th>
                <th style="border: 1px solid #ccc;">Analista</th>
                <th style="border: 1px solid #ccc;">Cliente</th>
                <th style="border: 1px solid #ccc;">Motivo</th>
                <th style="border: 1px solid #ccc;">Veiculo</th>
                <th style="border: 1px solid #ccc;">Data</th>
                <th style="border: 1px solid #ccc;">Valor</th>
            </tr>
        </thead>

        <tbody>
            @forelse ($contas as $conta)
                <tr>
                    <td style="border: 1px solid #ccc; border-top: none;">{{ $conta->id }}</td>
                    <td style="border: 1px solid #ccc; border-top: none;">{{ $conta->analista }}</td>
                    <td style="border: 1px solid #ccc; border-top: none;">{{ $conta->cliente }}</td>
                    <td style="border: 1px solid #ccc; border-top: none;">{{ $conta->motivo }}</td>
                    <td style="border: 1px solid #ccc; border-top: none;">{{ $conta->veiculo }}</td>
                    <td style="border: 1px solid #ccc; border-top: none;">{{ \Carbon\Carbon::parse($conta->data)->tz('America/Sao_Paulo')->format('d/m/Y') }}</td>
                    <td style="border: 1px solid #ccc; border-top: none;">{{ 'R$ ' . number_format($conta->valor, 2, ',', '.') }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="4">Nenhuma conta encontrada!</td>
                </tr>
            @endforelse

            <tr>
                <td colspan="3" style="border: 1px solid #ccc; border-top: none;">Total</td>
                <td style="border: 1px solid #ee0f0f; border-top: none; ">{{ 'R$ ' . number_format($totalValor, 2, ',', '.') }}</td>
            </tr>
        </tbody>

    </table>
</body>

</html>
